/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.network.packet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.api.common.skill.ISkillProperties;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.client.screen.skill.SkillTreeScreen;
import dev.toma.gunsrpg.common.debuffs.DynamicDebuff;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkRegistry;
import dev.toma.gunsrpg.common.skills.core.SkillCategory;
import dev.toma.gunsrpg.common.skills.core.SkillHierarchy;
import dev.toma.gunsrpg.common.skills.core.SkillProperties;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.common.skills.core.TransactionValidatorRegistry;
import dev.toma.gunsrpg.network.AbstractNetworkPacket;
import dev.toma.gunsrpg.resource.perks.PerkConfiguration;
import dev.toma.gunsrpg.resource.skill.SkillPropertyLoader;
import dev.toma.gunsrpg.util.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2C_SynchronizationPayloadPacket
extends AbstractNetworkPacket<S2C_SynchronizationPayloadPacket> {
    private static final Gson GSON = new GsonBuilder().create();
    private final List<DataContext> data;
    private final List<Perk> perks;
    private final PerkConfiguration configuration;
    private final Map<ResourceLocation, Object> debuffData;

    public S2C_SynchronizationPayloadPacket() {
        this(null, null, null, null);
    }

    public static <T> S2C_SynchronizationPayloadPacket makePayloadPacket() {
        Lifecycle lifecycle = GunsRPG.getModLifecycle();
        List<DataContext> data = ModRegistries.SKILLS.getValues().stream().filter(S2C_SynchronizationPayloadPacket::filterAndLogInvalid).map(DataContext::new).collect(Collectors.toList());
        ArrayList<Perk> perks = new ArrayList<Perk>(PerkRegistry.getRegistry().getPerks());
        PerkConfiguration configuration = lifecycle.getPerkManager().configLoader.getConfiguration();
        Map<ResourceLocation, Object> debuffData = lifecycle.getDebuffDataManager().getDebuffData();
        return new S2C_SynchronizationPayloadPacket(data, perks, configuration, debuffData);
    }

    private S2C_SynchronizationPayloadPacket(List<DataContext> data, List<Perk> perks, PerkConfiguration configuration, Map<ResourceLocation, Object> debuffData) {
        this.data = data;
        this.perks = perks;
        this.configuration = configuration;
        this.debuffData = debuffData;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.data.size());
        for (DataContext context : this.data) {
            context.encode(buffer);
        }
        buffer.writeInt(this.perks.size());
        this.perks.forEach(perk -> perk.encode(buffer));
        this.configuration.encode(buffer);
        buffer.writeInt(this.debuffData.size());
        this.debuffData.forEach((location, data) -> this.encodeDebuffData(buffer, (ResourceLocation)location, (Object)data));
    }

    @Override
    public S2C_SynchronizationPayloadPacket decode(PacketBuffer buffer) {
        int l = buffer.readInt();
        ArrayList<DataContext> list = new ArrayList<DataContext>();
        for (int i = 0; i < l; ++i) {
            list.add(new DataContext(buffer));
        }
        ArrayList<Perk> perks = new ArrayList<Perk>();
        int perkCount = buffer.readInt();
        for (int i = 0; i < perkCount; ++i) {
            perks.add(Perk.decode(buffer));
        }
        PerkConfiguration configuration = PerkConfiguration.decode(buffer);
        Map<ResourceLocation, Object> map = this.decodeDebuffData(buffer);
        return new S2C_SynchronizationPayloadPacket(list, perks, configuration, map);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        this.data.forEach(this::assign);
        SkillTreeScreen.Cache.invalidate();
        PerkRegistry registry = PerkRegistry.getRegistry();
        registry.dropRegistry();
        this.perks.forEach(perk -> registry.register(perk.getPerkId(), (Perk)perk));
        GunsRPG.getModLifecycle().getPerkManager().configLoader.setConfiguration(this.configuration);
        this.debuffData.forEach(this::handleDebuffData);
    }

    private <S extends ISkill> void assign(DataContext context) {
        SkillType owner = context.owner;
        SkillPropertyLoader.ILoadResult result = context.result;
        owner.onDataAssign(result);
    }

    private <D> void encodeDebuffData(PacketBuffer buffer, ResourceLocation location, D data) {
        buffer.func_192572_a(location);
        DynamicDebuff type = (DynamicDebuff)ModRegistries.DEBUFFS.getValue(location);
        Codec codec = type.getDataCodec();
        DataResult encodeResult = codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, data);
        CompoundNBT nbt = encodeResult.result().map(t -> (CompoundNBT)t).orElse(new CompoundNBT());
        buffer.func_150786_a(nbt);
    }

    private Map<ResourceLocation, Object> decodeDebuffData(PacketBuffer buffer) {
        HashMap<ResourceLocation, Object> map = new HashMap<ResourceLocation, Object>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            ResourceLocation location = buffer.func_192575_l();
            CompoundNBT nbt = buffer.func_150793_b();
            Object data = this.readDebuffData(location, nbt);
            map.put(location, data);
        }
        return map;
    }

    private <D> D readDebuffData(ResourceLocation location, CompoundNBT nbt) {
        DynamicDebuff debuff = (DynamicDebuff)ModRegistries.DEBUFFS.getValue(location);
        Codec codec = debuff.getDataCodec();
        DataResult result = codec.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt);
        return (D)result.result().orElseThrow(IllegalStateException::new);
    }

    private <D> void handleDebuffData(ResourceLocation location, D data) {
        DynamicDebuff debuff = (DynamicDebuff)ModRegistries.DEBUFFS.getValue(location);
        debuff.onDataLoaded(data);
    }

    private static boolean filterAndLogInvalid(SkillType<?> type) {
        ISkillHierarchy<?> hierarchy = type.getHierarchy();
        if (hierarchy == null) {
            GunsRPG.log.fatal("Skipping sync of {} skill, no data were loaded!", (Object)type.getRegistryName());
        }
        return hierarchy != null;
    }

    private static class DataContext {
        private SkillType<?> owner;
        private SkillPropertyLoader.ILoadResult<?> result;

        DataContext(SkillType<?> owner) {
            this.owner = owner;
        }

        DataContext(PacketBuffer buffer) {
            this.owner = this.fromResource(buffer.func_192575_l());
            boolean disabled = buffer.readBoolean();
            ISkillHierarchy<?> hierarchy = this.decodeHierarchy(buffer);
            ISkillProperties properties = this.decodeProperties(buffer);
            this.result = new SkillPropertyLoader.Result(hierarchy, properties, disabled);
        }

        public void encode(PacketBuffer to) {
            ISkillHierarchy<?> hierarchy = this.owner.getHierarchy();
            ISkillProperties properties = this.owner.getProperties();
            to.func_192572_a(this.owner.getRegistryName());
            to.writeBoolean(this.owner.isDisabled());
            this.encodeHierarchy(hierarchy, to);
            this.encodeProperties(properties, to);
        }

        private ISkillHierarchy<?> decodeHierarchy(PacketBuffer buffer) {
            int i;
            int l;
            SkillCategory category = (SkillCategory)buffer.func_179257_a(SkillCategory.class);
            byte flags = buffer.readByte();
            SkillType<?> parent = null;
            SkillType<?> override = null;
            SkillType[] children = null;
            SkillType[] extensions = null;
            if ((flags & 1) != 0) {
                parent = this.fromResource(buffer.func_192575_l());
            }
            if ((flags & 2) != 0) {
                override = this.fromResource(buffer.func_192575_l());
            }
            if ((flags & 4) != 0) {
                l = buffer.func_150792_a();
                children = new SkillType[l];
                for (i = 0; i < l; ++i) {
                    children[i] = this.fromResource(buffer.func_192575_l());
                }
            }
            if ((flags & 8) != 0) {
                l = buffer.func_150792_a();
                extensions = new SkillType[l];
                for (i = 0; i < l; ++i) {
                    extensions[i] = this.fromResource(buffer.func_192575_l());
                }
            }
            return new SkillHierarchy(category, parent, override, children, extensions);
        }

        private ISkillProperties decodeProperties(PacketBuffer buffer) {
            int level = buffer.func_150792_a();
            int price = buffer.func_150792_a();
            ResourceLocation id = buffer.func_192575_l();
            String string = buffer.func_218666_n();
            JsonElement element = new JsonParser().parse(string);
            Object factory = TransactionValidatorRegistry.getValidatorFactory(id);
            Object validator = TransactionValidatorRegistry.getTransactionValidator(factory, element);
            return new SkillProperties(level, price, (ITransactionValidator)validator);
        }

        private void encodeHierarchy(ISkillHierarchy<?> hierarchy, PacketBuffer buffer) {
            SkillCategory category = hierarchy.getCategory();
            SkillType<?> parent = hierarchy.getParent();
            SkillType<?> override = hierarchy.getOverride();
            SkillType<?>[] children = hierarchy.getChildren();
            SkillType<?>[] extension = hierarchy.getExtensions();
            byte flags = 0;
            flags = (byte)(flags | (parent != null ? 1 : 0));
            flags = (byte)(flags | (override != null ? 2 : 0));
            flags = (byte)(flags | (children != null ? 4 : 0));
            flags = (byte)(flags | (extension != null ? 8 : 0));
            buffer.func_179249_a((Enum)category);
            buffer.writeByte((int)flags);
            if (parent != null) {
                buffer.func_192572_a(parent.getRegistryName());
            }
            if (override != null) {
                buffer.func_192572_a(override.getRegistryName());
            }
            if (children != null) {
                buffer.func_150787_b(children.length);
                for (SkillType<?> child : children) {
                    buffer.func_192572_a(child.getRegistryName());
                }
            }
            if (extension != null) {
                buffer.func_150787_b(extension.length);
                for (SkillType<?> ext : extension) {
                    buffer.func_192572_a(ext.getRegistryName());
                }
            }
        }

        private void encodeProperties(ISkillProperties properties, PacketBuffer buffer) {
            ITransactionValidator validator = properties.getTransactionValidator();
            buffer.func_150787_b(properties.getRequiredLevel());
            buffer.func_150787_b(properties.getPrice());
            buffer.func_192572_a(validator.getId());
            String jsonString = GSON.toJson(validator.getData());
            buffer.func_180714_a(jsonString);
        }

        private SkillType<?> fromResource(ResourceLocation location) {
            return (SkillType)ModRegistries.SKILLS.getValue(location);
        }
    }
}

